Option Explicit
Const scriptName = "Make Fraction"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a selected fraction or a fraction before the insertion point in the active text flow."
Const errNoFraction = "No fraction was found in the provided text."

Dim fractionSlash
fractionSlash = ChrW(8260)




' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim textSel, isTextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

' Sanity check
If errNum = 0 Then
  On Error Resume Next
  Set textSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  End If
End If

Dim numStart, numEnd, denStart, denEnd, slashIndex, stopIndex, currentIndex, aChar
Dim foundSel, gotChar, allSet, foundDen
Dim theFlow
If errNum = 0 Then
  Set theFlow = textSel.TextFlow
  If TextSel.Start <= TextSel.End Then
    stopIndex = TextSel.Start
    foundSel = True
  Else
    stopIndex = 1
    foundSel = False
  End If
  
  allSet = False
  foundDen = False
  gotChar = True
  numStart = 0
  numEnd = 0
  denStart = 0
  denEnd = 0
  currentIndex = TextSel.End
  Do While (errNum = 0 And allSet = False)
    If (currentIndex < stopIndex) Then
      ' Skip to the exit:
      gotChar = False
    Else
      aChar = theFlow.Characters(currentIndex)
    End If
    
    If (gotChar And aChar >= "0" And aChar <= "9") Then
      If foundDen Then
        If numEnd = 0 Then
          numEnd = currentIndex
          numStart = currentIndex
        Else
          numStart = currentIndex
        End If
      Else
        If denEnd = 0 Then
          denEnd = currentIndex
          denStart = currentIndex
        Else
          denStart = currentIndex
        End If
      End If
      currentIndex = currentIndex - 1
    Elseif (gotChar And (aChar = "/" Or aChar = fractionSlash) And (numEnd = 0) And (denEnd <> 0) And (denStart <> 0)) Then
      foundDen = True
      slashIndex = currentIndex
      currentIndex = currentIndex - 1
    Else
      ' If we have a fraction, we're good.
      ' Otherwise, if we're not at the end and we haven't found a fraction yet, skip this char
      If (numStart <> 0 And numEnd <> 0 And foundDen) Then
        allSet = True
      Elseif (gotChar) And (denStart = 0) And (foundSel Or aChar = " ") Then
        currentIndex = currentIndex - 1
      Else
        errNum = -2
      End If
    End If
  Loop
End If

If errNum = 0 Then
  Dim tempRange
  Set tempRange = theFlow.Characters(slashIndex)
  tempRange.Text = fractionSlash
  tempRange.Superior = False
  tempRange.Inferior = False
  
  tempRange.Start = numStart
  tempRange.End = numEnd
  tempRange.Superior = True
  
  tempRange.End = denEnd
  tempRange.Start = denStart
  tempRange.Inferior = True
  
  tempRange.Start = numStart
  tempRange.Select
Elseif errNum = -2 Then
    Call MsgBox(errNoFraction, vbOkonly, scriptName)
End If
